﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Autodesk.Revit.DB;

namespace BauteillistenDrucken
{
    public partial class GUI : System.Windows.Forms.Form
    {
        private Document m_doc;
        private FilteredElementCollector m_schedules;

        public GUI()
        {
            InitializeComponent();
        }

        public GUI(Document rvtDOC) : this()
        {
            m_doc = rvtDOC;
        }

        private void GUI_Load(object sender, EventArgs e)
        {
            m_schedules = new FilteredElementCollector(m_doc).OfClass(typeof(ViewSchedule));
            foreach (Element elem in m_schedules)
            {
                scheduleList.Items.Add(elem.Name);
            }
        }

        private void OkButton_Click(object sender, EventArgs e)
        {
            listPrinter lp = new listPrinter();

            int cnt = 0;

            foreach (Element elem in m_schedules)
            {

                if (scheduleList.CheckedIndices.Contains(cnt))
                {
                    ViewSchedule vs = elem as ViewSchedule;
                    lp.print(vs);
                }
                cnt++;
            }
            this.Close();
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Close(); 
        }
    }
}
