﻿using System;
using System.IO;
using Autodesk.Revit.DB;
using Excel = Microsoft.Office.Interop.Excel;

namespace BauteillistenDrucken
{
    class listPrinter
    {
        private Excel.Application excelApp;
        static string AddInLocation = typeof(Ribbon).Assembly.Location;
        static string AppFolder = Path.GetDirectoryName(AddInLocation);


        public listPrinter()
        {
            excelApp = new Excel.Application();
        }

        public void print(ViewSchedule VS)
        {
            Excel.Workbook wb = excelApp.Workbooks.Add(Path.Combine(AppFolder, "Bauteillisten-Vorlage.xltx"));
            Excel.Worksheet ws = wb.Sheets[1];
            excelApp.Visible = false;

            TableSectionData bodySection = VS.GetTableData().GetSectionData(SectionType.Body);
            int numberOfRows = bodySection.NumberOfRows;
            int numberOfColumns = bodySection.NumberOfColumns;

            ws.Cells[1, 1] = VS.GetCellText(SectionType.Header, 0, 0);

            for (int iRow = bodySection.FirstRowNumber; iRow < numberOfRows; iRow++)
            {
                for (int iCol = bodySection.FirstColumnNumber; iCol < numberOfColumns; iCol++)
                {
                    string cText = bodySection.GetCellText(iRow, iCol);
                    ws.Cells[iRow + 2, iCol + 1] = VS.GetCellText(SectionType.Body, iRow, iCol);
                }
            }
            ws.PrintOutEx(Type.Missing, Type.Missing, 1, false);
            wb.Close(false);

        }

        ~listPrinter()
        {
            excelApp.Quit();
            System.Runtime.InteropServices.Marshal.ReleaseComObject(excelApp);

        }
    }
}


