#region Namespaces
using System;
using System.Windows;
using System.Windows.Media.Imaging;
using System.Collections.Generic;
using Autodesk.Revit.ApplicationServices;
using Autodesk.Revit.Attributes;
using Autodesk.Revit.DB;
using Autodesk.Revit.UI;
#endregion

namespace BauteillistenDrucken
{
    [Autodesk.Revit.Attributes.Transaction(Autodesk.Revit.Attributes.TransactionMode.Manual)]
    [Autodesk.Revit.Attributes.Regeneration(Autodesk.Revit.Attributes.RegenerationOption.Manual)]
    [Autodesk.Revit.Attributes.Journaling(Autodesk.Revit.Attributes.JournalingMode.NoCommandData)]

    class Ribbon : IExternalApplication
    {
        static String addinAssmeblyPath = typeof(Ribbon).Assembly.Location;

        public Result OnStartup(UIControlledApplication a)
        {
            CreateRibbonPanel(a);
            return Result.Succeeded;
        }

        public Result OnShutdown(UIControlledApplication a)
        {
            return Result.Succeeded;
        }

        /// <summary>
        /// This method is used to create Ribbon panel, and add command buttons to it:
        /// </summary>
        /// <param name="application">An object that is passed to the external application 
        /// which contains the controlled application.</param>
        private void CreateRibbonPanel(UIControlledApplication application)
        {
            // create a Ribbon panel which contains three stackable buttons and one single push button.
            string firstPanelName = "Bauteillisten";
            RibbonPanel ribbonPanel = application.CreateRibbonPanel(firstPanelName);

            #region 
            PushButtonData pbd = new PushButtonData("Command1", "Drucken", addinAssmeblyPath, "BauteillistenDrucken.Command");
            //ContextualHelp ch = new ContextualHelp(ContextualHelpType.ContextId, "HID_OBJECTS_WALL");
            //pbd.SetContextualHelp(ch);
            pbd.LongDescription = "Direktes Drucken von Bauteillisten auf dem aktuellen Standarddrucker.";
            pbd.LargeImage = convertFromBitmap(BauteillistenDrucken.Properties.Resources.RibbonIcon1Large);
            pbd.Image = convertFromBitmap(BauteillistenDrucken.Properties.Resources.RibbonIcon1Small);
            ribbonPanel.AddItem(pbd);
            #endregion

        }


        BitmapSource convertFromBitmap(System.Drawing.Bitmap bitmap)
        {
            return System.Windows.Interop.Imaging.CreateBitmapSourceFromHBitmap(
                bitmap.GetHbitmap(),
                IntPtr.Zero,
                Int32Rect.Empty,
                BitmapSizeOptions.FromEmptyOptions());
        }



    }


}
